//	Setup Access-Control-Allow-Origin on moodle:
//	/login/index.php
//	/login/logout.php

Moodle = {
	url: 'http://kreatywnie.lublin.eu/elearning',

	authorize: function(login, password, done) {
		$.ajax({
			type: 'POST',
			url: Moodle.url + '/login/index.php',
			crossDomain: true,
			contentType: 'application/x-www-form-urlencoded',
			data: {
				username: login,
				password: password
			},
			xhrFields: {
				withCredentials: true
			},
			beforeSend: function(xhr) {
				xhr.withCredentials = true;
			},
			success: Moodle.setup,
			complete: done
		});
	},
	login: function() {
		Moodle.authorize($('#UserStudentLoginForm_login').val(),
			$('#UserStudentLoginForm_password').val());
	},
	loginTeacher: function(done) {
		Moodle.authorize($('#UserAdministratorLoginForm_login').val(),
			$('#UserAdministratorLoginForm_password').val(), done);
	},
	setup: function() {
		$('#logoutButton').off('click');
		$('#logoutButton').on('click', function() {
			function logOut() {
				window.location.href = href;
			}
			var href = $(this).attr('href');
			$.ajax({
				type: 'GET',
				url: Moodle.url + '/login/logout.php',
				crossDomain: true,
				success: function(data) {
					var m = /<input type="hidden" name="sesskey" value="([a-zA-Z0-9]{1,})" \/>/.exec(data);
					if (m != null)
						$.ajax({
							type: 'GET',
							data: {
								sesskey: m[1]
							},
							url: Moodle.url + '/login/logout.php',
							crossDomain: true,
							complete: logOut
						});
					else logOut();
				},
				error: logOut
			});
			return false;
		});
		$('#user-student-login-form').off('submit');
		$('#user-student-login-form').on('submit', function() {
			$('input[type="submit"]').attr('disabled', true);
			Moodle.loginTeacher(function() {
				window.setTimeout(function() {
					$('#user-student-login-form').off('submit');
					$('#user-student-login-form').submit();
				}, 500);
			});
			return false;
		});
	}
}

$(document).ready(Moodle.setup);
